namespace gov.va.med.vbecs.Common
{

	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>VHA</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/28/2008</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///    VbecsBrokenRules - contains DB-2-code mapping of VBECS broken rules
	///
	///    The content in this file was generated by UpdateBrokenRules macro.
	///    Please do not modify the file manually since it should only contain 
	///    throw-away code which can be re-created by the macro.
	///
	///    Last time generated by DNS      \DNS   jensec at 7:27:59 AM, Tuesday, October 28, 2008
	///
	///    WARNING: re-generate the file every time the broken rules change!
	///</summary>

	#endregion

	public abstract class VbecsBrokenRules
	{
		/// <summary>
		/// Broken rules for class/form Division
		/// </summary>
		public abstract class Division
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "Division";

			/// <summary>
			/// List of all broken rules/field names for class/form Division
			/// </summary>
			public const string
				AccessionAreaNotSet = "AccessionAreaNotSet",
				DefaultPrinterNotSet = "DefaultPrinterNotSet",
				FacilityNameNotSet = "FacilityNameNotSet",
				LabelPrinterConfigNotSet = "LabelPrinterConfigNotSet",
				LockInactivityTimeoutInvalid = "LockInactivityTimeoutInvalid",
				LockInactivityTimeoutNotSet = "LockInactivityTimeoutNotSet",
				TimeZoneConfigNotSet = "TimeZoneConfigNotSet";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form Division
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgAdministrativeDataReportCriteria
		/// </summary>
		public abstract class DlgAdministrativeDataReportCriteria
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgAdministrativeDataReportCriteria";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgAdministrativeDataReportCriteria
			/// </summary>
			public const string
				EndDate = "EndDate",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgAdministrativeDataReportCriteria
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgCTRatioReportCriteria
		/// </summary>
		public abstract class DlgCTRatioReportCriteria
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgCTRatioReportCriteria";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgCTRatioReportCriteria
			/// </summary>
			public const string
				EndDate = "EndDate",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgCTRatioReportCriteria
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgEditMinimumReaction
		/// </summary>
		public abstract class DlgEditMinimumReaction
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgEditMinimumReaction";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgEditMinimumReaction
			/// </summary>
			public const string
				ExpectedMinimumReaction = "ExpectedMinimumReaction";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgEditMinimumReaction
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgIssueBloodDetails
		/// </summary>
		public abstract class DlgIssueBloodDetails
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgIssueBloodDetails";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgIssueBloodDetails
			/// </summary>
			public const string
				IssueDate = "IssueDate",
				IssuedBy = "IssuedBy",
				IssueToLocation = "IssueToLocation",
				RemoteStorageIdentity = "RemoteStorageIdentity",
				Transporter = "Transporter";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgIssueBloodDetails
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgIssuedReturnedReportCriteria
		/// </summary>
		public abstract class DlgIssuedReturnedReportCriteria
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgIssuedReturnedReportCriteria";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgIssuedReturnedReportCriteria
			/// </summary>
			public const string
				PrintDate = "PrintDate",
				PrinterName = "PrinterName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgIssuedReturnedReportCriteria
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgMaintainDivision
		/// </summary>
		public abstract class DlgMaintainDivision
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgMaintainDivision";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgMaintainDivision
			/// </summary>
			public const string
				IccbbaRegistrationNumber = "IccbbaRegistrationNumber",
				IconOrderAlertType = "IconOrderAlertType",
				IconOrdersNeededHours = "IconOrdersNeededHours",
				IconRefreshRate = "IconRefreshRate",
				MaximumSpecimenExpirationDays = "MaximumSpecimenExpirationDays",
				MedicalDirectorName = "MedicalDirectorName",
				PatientTestingConfiguration = "PatientTestingConfiguration",
				PrinterName = "PrinterName",
				PrintOrderAlertType = "PrintOrderAlertType",
				PrintOrderNeededHours = "PrintOrderNeededHours";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgMaintainDivision
				/// </summary>
				public const string
					Alerts = "Alerts",
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgMaintainMsbos
		/// </summary>
		public abstract class DlgMaintainMsbos
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgMaintainMsbos";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgMaintainMsbos
			/// </summary>
			public const string
				ComponentClassId = "ComponentClassId",
				MaximumSetupUnitQuantity = "MaximumSetupUnitQuantity",
				SurgeryName = "SurgeryName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgMaintainMsbos
				/// </summary>
				public const string
					Msbos = "Msbos",
					MsbosComponentClass = "MsbosComponentClass";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgOrderReportCriteria
		/// </summary>
		public abstract class DlgOrderReportCriteria
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgOrderReportCriteria";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgOrderReportCriteria
			/// </summary>
			public const string
				OrderGuid = "OrderGuid",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgOrderReportCriteria
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgPatientAvailabilityType
		/// </summary>
		public abstract class DlgPatientAvailabilityType
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgPatientAvailabilityType";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgPatientAvailabilityType
			/// </summary>
			public const string
				FinalDispositionEndDate = "FinalDispositionEndDate",
				Patient = "Patient",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName",
				ReportType = "ReportType";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgPatientAvailabilityType
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgPatientRecordReportCriteria
		/// </summary>
		public abstract class DlgPatientRecordReportCriteria
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgPatientRecordReportCriteria";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgPatientRecordReportCriteria
			/// </summary>
			public const string
				Patient = "Patient",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName",
				ReportSections = "ReportSections";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgPatientRecordReportCriteria
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgSelectSpecificities
		/// </summary>
		public abstract class DlgSelectSpecificities
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgSelectSpecificities";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgSelectSpecificities
			/// </summary>
			public const string
				AutoInstrumentName = "AutoInstrumentName",
				LotNumber = "LotNumber",
				RackName = "RackName",
				ReactivityPhaseCode = "ReactivityPhaseCode",
				ReagentTypeId = "ReagentTypeId",
				TestingMethodCode = "TestingMethodCode",
				WorklistCreateDate = "WorklistCreateDate",
				WorklistName = "WorklistName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgSelectSpecificities
				/// </summary>
				public const string
					AntiseraWorklist = "AntiseraWorklist",
					NoRack = "NoRack",
					PartialAntiseraWorklist = "PartialAntiseraWorklist",
					Rack = "Rack",
					RackLot = "RackLot",
					Reagent = "Reagent",
					ReagentType = "ReagentType";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgTestingWorklistCriteria
		/// </summary>
		public abstract class DlgTestingWorklistCriteria
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgTestingWorklistCriteria";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgTestingWorklistCriteria
			/// </summary>
			public const string
				EndDate = "EndDate",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName",
				ReportSections = "ReportSections";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgTestingWorklistCriteria
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgTransfusionComplicationDetails
		/// </summary>
		public abstract class DlgTransfusionComplicationDetails
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgTransfusionComplicationDetails";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgTransfusionComplicationDetails
			/// </summary>
			public const string
				EndDate = "EndDate",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgTransfusionComplicationDetails
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgTransfusionEffectivenessReportCriteria
		/// </summary>
		public abstract class DlgTransfusionEffectivenessReportCriteria
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgTransfusionEffectivenessReportCriteria";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgTransfusionEffectivenessReportCriteria
			/// </summary>
			public const string
				EndDate = "EndDate",
				Patient = "Patient",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgTransfusionEffectivenessReportCriteria
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form DlgTransfusionRequirementsReportCriteria
		/// </summary>
		public abstract class DlgTransfusionRequirementsReportCriteria
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "DlgTransfusionRequirementsReportCriteria";

			/// <summary>
			/// List of all broken rules/field names for class/form DlgTransfusionRequirementsReportCriteria
			/// </summary>
			public const string
				EndDate = "EndDate",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form DlgTransfusionRequirementsReportCriteria
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmAboIncompatibleTransfusion
		/// </summary>
		public abstract class FrmAboIncompatibleTransfusion
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmAboIncompatibleTransfusion";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmAboIncompatibleTransfusion
			/// </summary>
			public const string
				PatientLocation = "PatientLocation",
				ReactionIndicator = "ReactionIndicator",
				TransfusedVolume = "TransfusedVolume",
				TransfusionEndDateTime = "TransfusionEndDateTime",
				TransfusionEndDateTime2 = "TransfusionEndDateTime2",
				TransfusionInterrupted = "TransfusionInterrupted",
				TransfusionStartDateTime = "TransfusionStartDateTime",
				TransfusionStartDateTime3 = "TransfusionStartDateTime3";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmAboIncompatibleTransfusion
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmAddUser
		/// </summary>
		public abstract class FrmAddUser
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmAddUser";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmAddUser
			/// </summary>
			public const string
				UserName = "UserName",
				UserNTLoginId = "UserNTLoginId",
				UserRoleId = "UserRoleId";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmAddUser
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmBloodProductEdit
		/// </summary>
		public abstract class FrmBloodProductEdit
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmBloodProductEdit";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmBloodProductEdit
			/// </summary>
			public const string
				HcpcsCode = "HcpcsCode",
				LocalSupplierGuid = "LocalSupplierGuid",
				ProductCost = "ProductCost",
				ProductTypeCode = "ProductTypeCode",
				RecordStatusCode = "RecordStatusCode",
				ReturnCreditPercentage = "ReturnCreditPercentage";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmBloodProductEdit
				/// </summary>
				public const string
					Default = "default",
					ExistingProductSupplier = "ExistingProductSupplier",
					FirstEdit = "FirstEdit",
					NewProductSupplier = "NewProductSupplier",
					NewProductType = "NewProductType";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmBloodUnitMaintain
		/// </summary>
		public abstract class FrmBloodUnitMaintain
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmBloodUnitMaintain";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmBloodUnitMaintain
			/// </summary>
			public const string
				Abo = "Abo",
				Comments = "Comments",
				DonationTypeId = "DonationTypeId",
				LabelUnitId = "LabelUnitId",
				ProductCode = "ProductCode",
				UnitExpirationDate = "UnitExpirationDate",
				UnitFDARegistrationNumber = "UnitFDARegistrationNumber";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmBloodUnitMaintain
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmCollectionFacilityMaintain
		/// </summary>
		public abstract class FrmCollectionFacilityMaintain
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmCollectionFacilityMaintain";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmCollectionFacilityMaintain
			/// </summary>
			public const string
				ActiveIndicator = "ActiveIndicator",
				AddressLine1 = "AddressLine1",
				City = "City",
				FacilityIndicator = "FacilityIndicator",
				FacilityName = "FacilityName",
				FacilityPrefix = "FacilityPrefix",
				FDARegistrationNumber = "FDARegistrationNumber",
				LocalSupplierGuid = "LocalSupplierGuid",
				StateCode = "StateCode",
				ZipCode = "ZipCode";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmCollectionFacilityMaintain
				/// </summary>
				public const string
					ExistingAddress = "ExistingAddress",
					ExistingLocalSupplier = "ExistingLocalSupplier",
					NewAddress = "NewAddress",
					NewLocalSupplier = "NewLocalSupplier";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmConfigureComponents
		/// </summary>
		public abstract class FrmConfigureComponents
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmConfigureComponents";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmConfigureComponents
			/// </summary>
			public const string
				ComponentClassId = "ComponentClassId",
				MaximumTransfusionTime = "MaximumTransfusionTime",
				SpecimenType = "SpecimenType",
				Threshold = "Threshold";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmConfigureComponents
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmConfigureReagent
		/// </summary>
		public abstract class FrmConfigureReagent
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmConfigureReagent";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmConfigureReagent
			/// </summary>
			public const string
				DailyAlertTime = "DailyAlertTime",
				EnhancementMediaId = "EnhancementMediaId",
				NumberOfRacks = "NumberOfRacks",
				RackNamesIndicator = "RackNamesIndicator";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmConfigureReagent
				/// </summary>
				public const string
					DailyControl = "DailyControl",
					EnhancementMedia = "EnhancementMedia",
					ExistingDailyControl = "ExistingDailyControl";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmDefineEffectivenessTests
		/// </summary>
		public abstract class FrmDefineEffectivenessTests
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmDefineEffectivenessTests";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmDefineEffectivenessTests
			/// </summary>
			public const string
				LabTestName = "LabTestName",
				LabWorkloadCode = "LabWorkloadCode",
				SpecimenType = "SpecimenType";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmDefineEffectivenessTests
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmDefineLocations
		/// </summary>
		public abstract class FrmDefineLocations
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmDefineLocations";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmDefineLocations
			/// </summary>
			public const string
				LocationName = "LocationName",
				LocationType = "LocationType";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmDefineLocations
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmDiscardQuarantine
		/// </summary>
		public abstract class FrmDiscardQuarantine
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmDiscardQuarantine";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmDiscardQuarantine
			/// </summary>
			public const string
				CommentText = "CommentText",
				Details = "Details",
				UserDateTime = "UserDateTime";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmDiscardQuarantine
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmEditUnitFinancial
		/// </summary>
		public abstract class FrmEditUnitFinancial
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmEditUnitFinancial";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmEditUnitFinancial
			/// </summary>
			public const string
				ReturnCreditAmount = "ReturnCreditAmount",
				SpecialTestingCost = "SpecialTestingCost",
				SpecimenExpirationDateTimeBeforeCollectDateTime = "SpecimenExpirationDateTimeBeforeCollectDateTime",
				UnitCost = "UnitCost";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmEditUnitFinancial
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmEnableModifications
		/// </summary>
		public abstract class FrmEnableModifications
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmEnableModifications";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmEnableModifications
			/// </summary>
			public const string
				BloodComponentClassId = "BloodComponentClassId";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmEnableModifications
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmEnterPostTransfusionInfo
		/// </summary>
		public abstract class FrmEnterPostTransfusionInfo
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmEnterPostTransfusionInfo";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmEnterPostTransfusionInfo
			/// </summary>
			public const string
				PatientLocation = "PatientLocation",
				ReactionIndicator = "ReactionIndicator",
				TransfusedVolume = "TransfusedVolume",
				TransfusionEndDateTime = "TransfusionEndDateTime",
				TransfusionEndDateTime2 = "TransfusionEndDateTime2",
				TransfusionInterrupted = "TransfusionInterrupted",
				TransfusionStartDateTime = "TransfusionStartDateTime",
				TransfusionStartDateTime3 = "TransfusionStartDateTime3";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmEnterPostTransfusionInfo
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmIssueBloodComponents
		/// </summary>
		public abstract class FrmIssueBloodComponents
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmIssueBloodComponents";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmIssueBloodComponents
			/// </summary>
			public const string
				NoUnitsSelected = "NoUnitsSelected";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmIssueBloodComponents
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmLogInSupplies
		/// </summary>
		public abstract class FrmLogInSupplies
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmLogInSupplies";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmLogInSupplies
			/// </summary>
			public const string
				Comments = "Comments",
				InvoiceNumber = "InvoiceNumber",
				LotExpirationDate = "LotExpirationDate",
				LotNumber = "LotNumber",
				LotQuantity = "LotQuantity",
				ManufacturerName = "ManufacturerName",
				ReceiptDate = "ReceiptDate",
				SatisfactoryIndicator = "SatisfactoryIndicator",
				SupplyName = "SupplyName",
				SupplyType = "SupplyType";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmLogInSupplies
				/// </summary>
				public const string
					NewSupply = "NewSupply";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmMaintainComments
		/// </summary>
		public abstract class FrmMaintainComments
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmMaintainComments";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmMaintainComments
			/// </summary>
			public const string
				Comments = "Comments";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmMaintainComments
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmMaintainComplications
		/// </summary>
		public abstract class FrmMaintainComplications
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmMaintainComplications";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmMaintainComplications
			/// </summary>
			public const string
				LabTestName = "LabTestName",
				LabWorkloadCode = "LabWorkloadCode",
				SpecimenType = "SpecimenType",
				Threshold = "Threshold";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmMaintainComplications
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmMaintainEquipment
		/// </summary>
		public abstract class FrmMaintainEquipment
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmMaintainEquipment";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmMaintainEquipment
			/// </summary>
			public const string
				AddressLine1 = "AddressLine1",
				City = "City",
				MaintenanceActivity = "MaintenanceActivity",
				MaintenanceContractDate = "MaintenanceContractDate",
				MaintenanceResult = "MaintenanceResult",
				ManufacturerName = "ManufacturerName",
				SerialNumber = "SerialNumber",
				StateCode = "StateCode",
				ZipCode = "ZipCode";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmMaintainEquipment
				/// </summary>
				public const string
					Equipment = "Equipment",
					EquipmentMaintenance = "EquipmentMaintenance";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmMaintainSpecimen
		/// </summary>
		public abstract class FrmMaintainSpecimen
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmMaintainSpecimen";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmMaintainSpecimen
			/// </summary>
			public const string
				CannedCommentGuid = "CannedCommentGuid",
				Details = "Details",
				ExpirationExtension = "ExpirationExtension",
				MaximumSpecimenExpirationDays = "MaximumSpecimenExpirationDays",
				NewSpecimenExpirationDate = "NewSpecimenExpirationDate",
				Phlebotomist = "Phlebotomist",
				ProcessingTechId = "ProcessingTechId",
				SpecimenCollectionDate = "SpecimenCollectionDate",
				SpecimenExpirationDate = "SpecimenExpirationDate",
				SpecimenReceivedDate = "SpecimenReceivedDate",
				SpecimenUid = "SpecimenUid",
				UnacceptableSpecimenIndicator = "UnacceptableSpecimenIndicator";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmMaintainSpecimen
				/// </summary>
				public const string
					ExistingSpecimen = "ExistingSpecimen",
					NewSpecimen = "NewSpecimen";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmModifyUnits
		/// </summary>
		public abstract class FrmModifyUnits
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmModifyUnits";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmModifyUnits
			/// </summary>
			public const string
				Container = "Container",
				DiscardVolume = "DiscardVolume",
				NewContainerWeldIndicator = "NewContainerWeldIndicator",
				SCDWafer = "SCDWafer",
				TargetBloodProduct = "TargetBloodProduct",
				UnitExpirationDate = "UnitExpirationDate",
				Volume = "Volume";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmModifyUnits
				/// </summary>
				public const string
					ModifyControlClosed = "ModifyControlClosed",
					ModifyControlOpen = "ModifyControlOpen",
					ModifyControlSCD = "ModifyControlSCD",
					ModifyModifiedUnitClosed = "ModifyModifiedUnitClosed",
					ModifyModifiedUnitOpen = "ModifyModifiedUnitOpen",
					ModifyModifiedUnitSCD = "ModifyModifiedUnitSCD";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmNewEquipment
		/// </summary>
		public abstract class FrmNewEquipment
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmNewEquipment";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmNewEquipment
			/// </summary>
			public const string
				AddressLine1 = "AddressLine1",
				City = "City",
				EquipmentName = "EquipmentName",
				EquipmentType = "EquipmentType",
				MaintenanceContractDate = "MaintenanceContractDate",
				ManufacturerName = "ManufacturerName",
				SerialNumber = "SerialNumber",
				StateCode = "StateCode",
				ZipCode = "ZipCode";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmNewEquipment
				/// </summary>
				public const string
					Equipment = "Equipment";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmPendingOrderSearch
		/// </summary>
		public abstract class FrmPendingOrderSearch
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmPendingOrderSearch";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmPendingOrderSearch
			/// </summary>
			public const string
				AccessionNumber = "AccessionNumber",
				UnacceptableSpecimenIndicator = "UnacceptableSpecimenIndicator";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmPendingOrderSearch
				/// </summary>
				public const string
					Default = "default",
					ExistingSpecimen = "ExistingSpecimen";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmPoolUnits
		/// </summary>
		public abstract class FrmPoolUnits
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmPoolUnits";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmPoolUnits
			/// </summary>
			public const string
				Container = "Container",
				NewContainerWeldIndicator = "NewContainerWeldIndicator",
				SCDWafer = "SCDWafer",
				TargetBloodProduct = "TargetBloodProduct",
				UnitExpirationDate = "UnitExpirationDate",
				Volume = "Volume";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmPoolUnits
				/// </summary>
				public const string
					EditPoolControl = "EditPoolControl",
					EditPoolModifiedUnit = "EditPoolModifiedUnit",
					PoolControlClosed = "PoolControlClosed",
					PoolControlOpen = "PoolControlOpen",
					PoolControlSCD = "PoolControlSCD",
					PoolModifiedUnitClosed = "PoolModifiedUnitClosed",
					PoolModifiedUnitOpen = "PoolModifiedUnitOpen",
					PoolModifiedUnitSCD = "PoolModifiedUnitSCD";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmPrintCautionTagByPatient
		/// </summary>
		public abstract class FrmPrintCautionTagByPatient
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmPrintCautionTagByPatient";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmPrintCautionTagByPatient
			/// </summary>
			public const string
				OverrideComment = "OverrideComment";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmPrintCautionTagByPatient
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmPrintCautionTagByUnit
		/// </summary>
		public abstract class FrmPrintCautionTagByUnit
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmPrintCautionTagByUnit";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmPrintCautionTagByUnit
			/// </summary>
			public const string
				OverrideComment = "OverrideComment";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmPrintCautionTagByUnit
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmProcessShipmentIn
		/// </summary>
		public abstract class FrmProcessShipmentIn
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmProcessShipmentIn";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmProcessShipmentIn
			/// </summary>
			public const string
				Abo = "Abo",
				CheckCharacter = "CheckCharacter",
				DirectedPatient = "DirectedPatient",
				DonationTypeCode = "DonationTypeCode",
				SpecialTestingCost = "SpecialTestingCost",
				TestingStatusId = "TestingStatusId",
				UnitExpirationDate = "UnitExpirationDate",
				UnitFdaRegistrationNumber = "UnitFdaRegistrationNumber";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmProcessShipmentIn
				/// </summary>
				public const string
					BloodUnitFinance = "BloodUnitFinance",
					BloodUnitMedia = "BloodUnitMedia",
					Codabar_ABORh = "Codabar_ABORh",
					Codabar_BloodUnit = "Codabar_BloodUnit",
					Codabar_DonationType = "Codabar_DonationType",
					ISBT128_ABORh = "ISBT128_ABORh",
					ISBT128_BloodUnit = "ISBT128_BloodUnit",
					ISBT128_DonationType = "ISBT128_DonationType";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmRecordSupplyUsage
		/// </summary>
		public abstract class FrmRecordSupplyUsage
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmRecordSupplyUsage";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmRecordSupplyUsage
			/// </summary>
			public const string
				AvailableQuantity = "AvailableQuantity",
				Comments = "Comments",
				InventoryChangeDate = "InventoryChangeDate";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmRecordSupplyUsage
				/// </summary>
				public const string
					UpdateSupply = "UpdateSupply";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmSelectUnitsForPatient
		/// </summary>
		public abstract class FrmSelectUnitsForPatient
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmSelectUnitsForPatient";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmSelectUnitsForPatient
			/// </summary>
			public const string
				OptionalCrossmatchUnits = "OptionalCrossmatchUnits";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmSelectUnitsForPatient
				/// </summary>
				public const string
					Default = "default";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmShipmentIn
		/// </summary>
		public abstract class FrmShipmentIn
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmShipmentIn";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmShipmentIn
			/// </summary>
			public const string
				InvoiceNumber = "InvoiceNumber",
				LocalSupplierGuid = "LocalSupplierGuid",
				ShipmentDate = "ShipmentDate",
				ShipmentDirection = "ShipmentDirection",
				ShipmentType = "ShipmentType";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmShipmentIn
				/// </summary>
				public const string
					LocalSupplier = "LocalSupplier",
					Shipment = "Shipment";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmSplitUnit
		/// </summary>
		public abstract class FrmSplitUnit
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmSplitUnit";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmSplitUnit
			/// </summary>
			public const string
				Container = "Container",
				NewContainerWeldIndicator = "NewContainerWeldIndicator",
				SCDWafer = "SCDWafer",
				UnitExpirationDate = "UnitExpirationDate",
				Volume = "Volume";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmSplitUnit
				/// </summary>
				public const string
					SplitControlCloseds = "SplitControlCloseds",
					SplitControlOpens = "SplitControlOpens",
					SplitControlSCD = "SplitControlSCD",
					SplitControlSCDs = "SplitControlSCDs",
					SplitModifiedUnitClosed = "SplitModifiedUnitClosed",
					SplitModifiedUnitOpen = "SplitModifiedUnitOpen",
					SplitModifiedUnitSCD = "SplitModifiedUnitSCD";
			}
		}

		/// <summary>
		/// Broken rules for class/form FrmTransfusionReactionWorkup
		/// </summary>
		public abstract class FrmTransfusionReactionWorkup
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "FrmTransfusionReactionWorkup";

			/// <summary>
			/// List of all broken rules/field names for class/form FrmTransfusionReactionWorkup
			/// </summary>
			public const string
				PostSpecimenHemolysisInspectionCode = "PostSpecimenHemolysisInspectionCode",
				PreSpecimenHemolysisInspectionCode = "PreSpecimenHemolysisInspectionCode",
				SpecimenUid = "SpecimenUid";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form FrmTransfusionReactionWorkup
				/// </summary>
				public const string
					PostSpecimenTrwAvailable = "PostSpecimenTrwAvailable",
					PreSpecimenTrwAvailable = "PreSpecimenTrwAvailable",
					TrwHemolysis = "TrwHemolysis";
			}
		}

		/// <summary>
		/// Broken rules for class/form HL7InterfaceConfig
		/// </summary>
		public abstract class HL7InterfaceConfig
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "HL7InterfaceConfig";

			/// <summary>
			/// List of all broken rules/field names for class/form HL7InterfaceConfig
			/// </summary>
			public const string
				AckTimeoutNotSet = "AckTimeoutNotSet",
				AckTimeoutOutOfRange = "AckTimeoutOutOfRange",
				InterfaceAdministratorEmailInvalid = "InterfaceAdministratorEmailInvalid",
				InterfaceAdministratorEmailNotSet = "InterfaceAdministratorEmailNotSet",
				InterfaceFacilityIdsMatch = "InterfaceFacilityIdsMatch",
				InterfaceFacilityIdNotSet = "InterfaceFacilityIdNotSet",
				InterfaceIPAddressAndDomainNameNotSpecified = "InterfaceIPAddressAndDomainNameNotSpecified",
				InterfaceIPAddressNotSet = "InterfaceIPAddressNotSet",
				InterfacePortNumberNotSet = "InterfacePortNumberNotSet",
				InterfacePortNumberOutOfRange = "InterfacePortNumberOutOfRange",
				PurgeSuccessfulMessageOutOfRange = "PurgeSuccessfulMessageOutOfRange",
				PurgeSuccessfulMessagesNotSet = "PurgeSuccessfulMessagesNotSet",
				PurgeUnSuccessfulMessageNotSet = "PurgeUnSuccessfulMessageNotSet",
				PurgeUnSuccessfulMessageOutOfRange = "PurgeUnSuccessfulMessageOutOfRange",
				ReTransmitAttemptsNotSet = "ReTransmitAttemptsNotSet",
				ReTransmitAttemptsOutOfRange = "ReTransmitAttemptsOutOfRange",
				VbecsIPAddressNotSet = "VbecsIPAddressNotSet",
				VbecsPortNumberNotSet = "VbecsPortNumberNotSet",
				VbecsPortNumberOutOfRange = "VbecsPortNumberOutOfRange";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form HL7InterfaceConfig
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}

		/// <summary>
		/// Broken rules for class/form InappropriateTransfusionRequestReport
		/// </summary>
		public abstract class InappropriateTransfusionRequestReport
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "InappropriateTransfusionRequestReport";

			/// <summary>
			/// List of all broken rules/field names for class/form InappropriateTransfusionRequestReport
			/// </summary>
			public const string
				EndDate = "EndDate",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form InappropriateTransfusionRequestReport
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}

		/// <summary>
		/// Broken rules for class/form LabelPrinterConfig
		/// </summary>
		public abstract class LabelPrinterConfig
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "LabelPrinterConfig";

			/// <summary>
			/// List of all broken rules/field names for class/form LabelPrinterConfig
			/// </summary>
			public const string
				ComPortNumberNotSet = "ComPortNumberNotSet",
				ComPortNumberOutOfRange = "ComPortNumberOutOfRange",
				ListenerIPAddressNotSet = "ListenerIPAddressNotSet",
				ListenerTcpPortNumberNotSet = "ListenerTcpPortNumberNotSet",
				ListenerTcpPortNumberOutOfRange = "ListenerTcpPortNumberOutOfRange";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form LabelPrinterConfig
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}

		/// <summary>
		/// Broken rules for class/form ProlongedTransfusionReport
		/// </summary>
		public abstract class ProlongedTransfusionReport
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "ProlongedTransfusionReport";

			/// <summary>
			/// List of all broken rules/field names for class/form ProlongedTransfusionReport
			/// </summary>
			public const string
				EndDate = "EndDate",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form ProlongedTransfusionReport
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}

		/// <summary>
		/// Broken rules for class/form TimeZoneConfig
		/// </summary>
		public abstract class TimeZoneConfig
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "TimeZoneConfig";

			/// <summary>
			/// List of all broken rules/field names for class/form TimeZoneConfig
			/// </summary>
			public const string
				CustomDaylightSavingsEndNotSet = "CustomDaylightSavingsEndNotSet",
				CustomDaylightSavingsStartGreatherThanEnd = "CustomDaylightSavingsStartGreatherThanEnd",
				CustomDaylightSavingsStartNotSet = "CustomDaylightSavingsStartNotSet",
				DaylightSavingsTypeNotSet = "DaylightSavingsTypeNotSet",
				TimeZoneNotSet = "TimeZoneNotSet";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form TimeZoneConfig
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}

		/// <summary>
		/// Broken rules for class/form TransfusionReport
		/// </summary>
		public abstract class TransfusionReport
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "TransfusionReport";

			/// <summary>
			/// List of all broken rules/field names for class/form TransfusionReport
			/// </summary>
			public const string
				EndDate = "EndDate",
				Locations = "Locations",
				Physicians = "Physicians",
				PrintDate = "PrintDate",
				PrinterName = "PrinterName",
				Specialty = "Specialty";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form TransfusionReport
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}

		/// <summary>
		/// Broken rules for class/form UserDivisionRole
		/// </summary>
		public abstract class UserDivisionRole
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "UserDivisionRole";

			/// <summary>
			/// List of all broken rules/field names for class/form UserDivisionRole
			/// </summary>
			public const string
				Role = "Role";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form UserDivisionRole
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}

		/// <summary>
		/// Broken rules for class/form VbecsUser
		/// </summary>
		public abstract class VbecsUser
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "VbecsUser";

			/// <summary>
			/// List of all broken rules/field names for class/form VbecsUser
			/// </summary>
			public const string
				DivisionDuzMismatch = "DivisionDuzMismatch",
				UserDuzInvalid = "UserDuzInvalid",
				UserDuzIsNotUnique = "UserDuzIsNotUnique",
				UserDuzNotSet = "UserDuzNotSet",
				UserEmailInvalid = "UserEmailInvalid",
				UserInitialsAreNotUnique = "UserInitialsAreNotUnique",
				UserInitialsAreTooLong = "UserInitialsAreTooLong",
				UserInitialsNotSet = "UserInitialsNotSet",
				UserNameTooLong = "UserNameTooLong",
				UserNtLoginIdInvalid = "UserNtLoginIdInvalid",
				UserNtLoginIdNotSet = "UserNtLoginIdNotSet",
				UserNtLoginIsNotUnique = "UserNtLoginIsNotUnique",
				UserNtNameNotSet = "UserNtNameNotSet",
				VistaUserNameIsNotUnique = "VistaUserNameIsNotUnique",
				VistaUserNameNotSet = "VistaUserNameNotSet",
				VistaUserNameTooLong = "VistaUserNameTooLong";

			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form VbecsUser
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}

		/// <summary>
		/// Broken rules for class/form VistaLinkConfig
		/// </summary>
		public abstract class VistaLinkConfig
		{
			/// <summary>
			/// Name of form/class
			/// </summary>
			public const string
				FormClassName = "VistaLinkConfig";

			/// <summary>
			/// List of all broken rules/field names for class/form VistaLinkConfig
			/// </summary>
			public const string
				VistaServerIpAddressAndDomainNameBothSpecified = "VistaServerIpAddressAndDomainNameBothSpecified",
				VistaServerIpAddressAndDomainNameNotSpecified = "VistaServerIpAddressAndDomainNameNotSpecified",
				VistaServerIpAddressNotSet = "VistaServerIpAddressNotSet",
				VistaServerPortNumberNotSet = "VistaServerPortNumberNotSet",
				VistaServerPortNumberOutOfRange = "VistaServerPortNumberOutOfRange",
                VbecsServiceIpAddressNotSet = "VbecsServiceIpAddressNotSet",
                VbecsServicePortNumberNotSet = "VbecsServicePortNumberNotSet",
                VbecsServicePortNumberOutOfRange = "VbecsServicePortNumberOutOfRange";


			/// <summary>
			/// Rule sets
			/// </summary>
			public abstract class RuleSets
			{
				/// <summary>
				/// Rule sets for a form VistaLinkConfig
				/// </summary>
				public const string
					BaseRuleSet = "BaseRuleSet";
			}
		}


	}
}
